/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import CH.ifa.draw.figures.RectangleFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import DE.siemens.ad.logo.app.action.CompositeUndoableAction;
import DE.siemens.ad.logo.app.comp.SplittedDlg;
import DE.siemens.ad.logo.dialog.SpacePanel;
import DE.siemens.ad.logo.util.Global;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.pdraw.action.MoveFigureAction;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.figures.BlockFigure;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.util.FigureYPositionComparator;
import DE.siemens.ad.udf.LogoDrawingUDF;
import DE.siemens.ad.udf.LogoDrawingViewUDF;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public class SpaceVerticalAction
extends CompositeUndoableAction {
    private static final long serialVersionUID = -3491464181457164545L;

    public SpaceVerticalAction() {
        this.putValue("Name", "AlignSpaceDown");
        this.putValue("textKey", "format.align.spacedown");
        this.putValue("SmallIcon", Global.getIcon("AlignDown.gif"));
        this.putValue("ShortDescription", Language.getStringNoTilde("format.align.spacedown", "Vertically dirtribute space"));
    }

    private void moveToYPosition(Figure figure, int Dy) {
        MoveFigureAction moveAction = null;
        moveAction = new MoveFigureAction();
        moveAction.setOwner(this.getOwner());
        moveAction.setFigure(figure);
        moveAction.setMoveVector(new Dimension(0, Dy));
        this.children.add(moveAction);
    }

    public boolean prepareAction() {
        SpacePanel spacePanel = new SpacePanel();
        SplittedDlg dialog = SplittedDlg.create(null, spacePanel, 3);
        dialog.show();
        if (dialog.getControlPanel().getResult() != 1) {
            return false;
        }
        DrawingView view = ((LogoComfort)this.getOwner()).view();
        Vector<BlockFigure> selectedBlockFigures = new Vector<BlockFigure>();
        Enumeration selectedFigures = view.selection().elements();
        Figure f = null;
        while (selectedFigures.hasMoreElements()) {
            f = (Figure)selectedFigures.nextElement();
            if (!(f instanceof BlockFigure)) continue;
            selectedBlockFigures.add((BlockFigure)f);
        }
        this.children.removeAllElements();
        Collections.sort(selectedBlockFigures, new FigureYPositionComparator());
        int lastY = ((BlockFigure)selectedBlockFigures.elementAt((int)0)).getImageFigure().displayBox().y - spacePanel.getSpace();
        for (int i = 0; i < selectedBlockFigures.size(); ++i) {
            int curSpace = ((BlockFigure)selectedBlockFigures.get((int)i)).getImageFigure().displayBox().y - lastY;
            this.moveToYPosition((Figure)selectedBlockFigures.get(i), spacePanel.getSpace() - curSpace);
            lastY += spacePanel.getSpace() + this.getFigureHeightWithGridSupports(view, (BlockFigure)selectedBlockFigures.elementAt(0));
        }
        if (view instanceof LogoDrawingViewUDF) {
            int maxY = lastY + ((BlockFigure)selectedBlockFigures.lastElement()).displayBox().height;
            RectangleFigure udfBox = ((LogoDrawingUDF)view.drawing()).getEditUDFFigure().getUDFBoxFigure();
            if (udfBox.displayBox().y + udfBox.displayBox().height < maxY) {
                udfBox.displayBox(new Point(udfBox.displayBox().x, udfBox.displayBox().y), new Point(udfBox.displayBox().x + udfBox.displayBox().width, maxY));
            }
        }
        return super.prepareAction();
    }

    private int getFigureHeightWithGridSupports(DrawingView view, BlockFigure figure) {
        if (((LogoDrawingView)view).getGridInfo().gridAttractionIsOn()) {
            int gridDistance = ((LogoDrawingView)view).getGridInfo().getDistance();
            return (figure.getImageFigure().displayBox().height + gridDistance - 1) / gridDistance * gridDistance;
        }
        return figure.getImageFigure().displayBox().height;
    }
}

